
// This scilab code is to perform image enhancement by adjusting the intensity values in the image
//which also called as histogram equalization.

//The scilab environment for this is : Scilab 6.0.1

//Toolbox used: Image Processing and Computer Vision Toolbox ver. 1.1
              

//OS used : Windows 10 64 bit
// 
//Reference book name : Digital Image Processing
//book author: Rafael C. Gonzalez and Richard E. Woods

clc //to clear command window.
clear all //to kill previously defined variables.
xdel(winsid())//to close all currently open figure(s).

//This code uses lenna.png image file for processing


img=imread('lenna.png');                    // Reads original lenna (color) image
grayImg=rgb2gray(img);                      // Converts color image to gray scale image
histequalImg=imhistequal(grayImg);          // Perform image enhancement using intensity adjustment i.e. histogram equalization
imshow(img);                                // Displays original lenna image
figure;imshow(grayImg);                     // Display resultant gray scale image
figure;imshow(histequalImg);                // Displyas resultant histogram equalized image
